<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\AuthController;

// WordPress JWT Auth style routes
Route::group(['prefix' => 'jwt-auth/v1'], function () {
    Route::post('token', [AuthController::class, 'token']);
    Route::post('token/validate', [AuthController::class, 'validateToken']);
});

// Listar custom auth routes
Route::group(['prefix' => 'listar/v1'], function () {
    Route::post('auth/register', [AuthController::class, 'register']);
    Route::get('auth/user', [AuthController::class, 'user'])->middleware('auth:api');
    
    Route::get('home/init', [App\Http\Controllers\Api\HomeController::class, 'init']);
    Route::get('home/widget', [App\Http\Controllers\Api\HomeController::class, 'widget']);
    
    Route::get('category/list', [App\Http\Controllers\Api\CategoryController::class, 'list']);
    
    Route::get('place/list', [App\Http\Controllers\Api\ListingController::class, 'index']); // Need to implement index
    Route::get('place/view', [App\Http\Controllers\Api\ListingController::class, 'show']); // Need to implement show
});

Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});
