<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Category;
use Illuminate\Http\Request;

class CategoryController extends Controller
{
    public function list(Request $request)
    {
        $categories = Category::whereNull('parent_id')->with('children')->get();
        
        // Transform to match legacy if needed, or return generic structure
        return response()->json([
            'success' => true,
            'data' => $categories
        ]);
    }
}
